# Script PEM – Lucas Legendre
# SEP 27 – December 9, 2020
# Compiled in R version 4.0.3 (2020-10-10)
# Modified by Romain Pellarin

# WARNING: edit the working directory to your preferred folder
setwd("C:")

# Loading packages
library(MPSEM)
library(evobiR)
library(phytools)
library(Metrics)

# Data
data<-read.table((file=file.choose()), header=T)
data
# Tree
tree<-read.nexus(file=file.choose())
plot(tree)
# Remove extra species in the tree that are absent from the dataset (here, none)
treeT<-drop.tip(tree, setdiff(tree$tip.label, data$species))
plotTree(treeT) # just to check

# Match the order of species in the dataset with that in the tree (here, already identical)
ReorderData(tree, data, taxa.names = "species")

data[,c(2,3)]<-log(data[,c(2,3)]) # log transformation for column 2 & 3 

### PEM ###

# Extract eigenvectors from the tree
grloc <- getGraphLocations(tree,data[is.na(data[,"MMR"]),"species"]) # phylogeny is expressed as eigenvectors
sporder <- match(attr(grloc$x,"vlabel")[grloc$x$vertex$species],data[,"species"])

# Build the PEM
aux <- c("Qi") # List of additional variables


PEMfs <- list()
for(m in aux) {
  PEMfs[[m]] <- PEM.fitSimple(y=data[sporder,"MMR"],
                              x=data[sporder,m],w=grloc$x,d="distance",sp="species",lower=0,upper=1)
  PEMfs[["none"]] <- PEM.fitSimple(y=data[sporder,"MMR"],
                                   x=NULL,w=grloc$x,d="distance",sp="species",lower=0,upper=1)
} ; rm(m)

for(m in c(aux,"none")) print(PEMfs[[m]]$optim$par) # Value of alpha parameter 
rm(m) 

# Select the best model (with one of the co-predictors or without co-predictors) based on AICc
PEMAIC <- list()
for(m in aux) {
  PEMAIC[[m]] <- lmforwardsequentialAICc(y=data[sporder,"MMR"],
                                         x=data[sporder,m,drop=FALSE],object=PEMfs[[m]])
  PEMAIC[["none"]] <- lmforwardsequentialAICc(y=data[sporder,"MMR"],object=PEMfs[["none"]])
}


summary(PEMAIC[["Qi"]]) 
# Predicting missing values for MMR

m <- "Qi" 

atr <- data[is.na(data[,"MMR"]),m,drop=FALSE]
resultsPEM<-predict(object=PEMfs[[m]],targets=grloc,lmobject=PEMAIC[[m]],newdata=atr,interval="confidence")

# Predicted MMR, with upper and lower limits of the confidence interval for the prediction:
exp(resultsPEM$values); exp(resultsPEM$upper); exp(resultsPEM$lower) # Inferred values of MMR 
PEMfs$none$u 


### Plot with the phylogeny, values, and confidence intervals ###

# Objects for predicted and fitted values
if(m == "none") {
  ypred <- predict(object=PEMfs[[m]],targets=grloc,lmobject=PEMAIC[[m]],interval="confidence")
} else {
  atr <- data[is.na(data[,"MMR"]),m,drop=FALSE]
  ypred <- predict(object=PEMfs[[m]],targets=grloc,lmobject=PEMAIC[[m]],newdata=atr,interval="confidence")
}
yfit <- numeric(length(PEMAIC[[m]]$fitted.values)) ; yfit[sporder] <- PEMAIC[[m]]$fitted.values

data<-read.table("MMRdata_a.txt", header=T) # Reload data to plot it with log10 conversion. Use MMRdata_a for MPV.2010.3.611a; MMRdata_b for MPV.2010.3.611b

# Order of tips in the tree for the plot
tree2<-ladderize(tree)
is_tip <- tree2$edge[,2] <= length(tree2$tip.label)
ordered_tips <- tree2$edge[is_tip, 2]
tree2$tip.label[ordered_tips]

# Plot the tree and axis
layout(matrix(c(1,1,2),1L,3L))
par(mar=c(4,1,1,1))
plot(tree2,cex=1.25)
lab <- log10(range(data[,"MMR"],na.rm=TRUE)) ; lab <- c(floor(lab[1L]),ceiling(lab[2L]))
plot(NA,ylim=c(1L,length(tree2$tip.label)),xlim=lab,axes=FALSE,xlab="MMR (mLO2 h-1 g-1)")
lab <- lab[1L]:lab[2L]
axis(1,at=lab,label=10^lab)

# Plot the observed, fitted, and predicted values
points(y=match(data[!is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       x=log10(data[!is.na(data[,"MMR"]),"MMR"]),pch=22,bg="white",cex=2)
points(y=match(data[!is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       x=log10(exp(yfit)),pch=4,cex=2)
points(y=match(data[is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       x=log10(exp(ypred$value)),pch=22,bg="black",cex=2)
arrows(y0=match(data[is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       y1=match(data[is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       x0=log10(exp(ypred$values)),x1=log10(exp(ypred$upper)),length=0.05,angle=90)
arrows(y0=match(data[is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       y1=match(data[is.na(data[,"MMR"]),"species"],tree2$tip.label[ordered_tips]),
       x0=log10(exp(ypred$values)),x1=log10(exp(ypred$lower)),length=0.05,angle=90)
legend(x=-0.2,y=16,pch=c(22,22,4),pt.bg=c("white","black","white"),legend=c("Observed","Predicted (95%)","Fitted"),title="Trait values")


